% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_range.R
\name{fitLoess}
\alias{fitLoess}
\title{Fit a loess curve}
\usage{
fitLoess(y, x, newx = x, span = 0.5, ...)
}
\arguments{
\item{y}{Dependent variable values}

\item{x}{Independent variable values}

\item{newx}{Values of x to use for prediction.}

\item{span}{Controls the amount of smoothing. Passed to \code{\link[stats]{loess}}; see that function for details.}

\item{...}{Additional arguments passed to \code{\link[stats]{loess}}}
}
\value{
A vector of the same length of \code{newx} providing the predictions from a loess smooth.
}
\description{
Wrapper function for fitting and predicting from \code{loess()}.
}
\examples{
x <- seq(0, 5, length=50)
y <- cos(4*x) + rnorm(50, sd=0.5)
xplot <- seq(0, 5, length=200)
lfit <- fitLoess(y=y, x=x, newx=xplot, span=0.2)
plot(x, y)
points(xplot, lfit, type="l")
}
