% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{BBTm.ties}
\alias{BBTm.ties}
\title{Bayesian inference for the Bradley--Terry model with ties}
\usage{
BBTm.ties(
  n.objects,
  outcome,
  player1,
  player2,
  player.prior.var = NULL,
  theta.initial = NULL,
  lambda.initial = NULL,
  n.iter = 1000,
  hyperparameter = TRUE,
  chi = 0.01,
  psi = 0.01,
  rw.sd = 0.1,
  theta.rate = 0.01
)
}
\arguments{
\item{n.objects}{number of objects in the study}

\item{outcome}{vector of outcomes. 0 if player 1 is the winner,
1 if player 2 is the winner, and 2 if it is a tie.}

\item{player1}{vector of first players.}

\item{player2}{vector of second players.}

\item{player.prior.var}{(optional) matrix specifying the prior covariance of
the player correlation parameters}

\item{theta.initial}{(optional) value of the tied parameter there for
the first MCMC iteration}

\item{lambda.initial}{(optional) vector containing the values of the
player parameters for the first MCMC iteration}

\item{n.iter}{number of MCMC samples to be drawn}

\item{hyperparameter}{boolean indicating if inference should be performed
for the prior variance hyperparameter. If TRUE the prior variance
(main diagonal of the covariance matrix) must be set to 1.}

\item{chi}{rate parameter for the inverse-gamma prior distribution on the
hyperparameter}

\item{psi}{shape parameter for the inverse-gamma prior distribution on the
hyperparameter}

\item{rw.sd}{number describing the standard deviation of normal distribution
proposal distribution for theta}

\item{theta.rate}{(optional) The rate parameter of the exponential prior
distribution placed on theta}
}
\value{
A data frame containing samples from the posterior distribution
}
\description{
This function uses MCMC to sample from the posterior distribution of the
Bradley--Terry model with ties.A multivariate normal prior
distribution on the player quality parameters can be specified. An exponential
prior distribution is placed on the tie parameter theta, and a Metropolis-
Hasting random walk algorithm is used to update this parameter.
}
\details{
If \code{player.prior.var} is omitted, independent and identical
N(0, 5^2) prior distributions are placed on each object quality parameter.

If \code{lambda.initial} is omitted, it is set to a vector of zeroes.
}
\examples{

############################################
## Deprivation in Dar es Salaam, Tanzania ##
## Seymour et al (2022)                   ##
############################################

#Construct covariance matrix based on spatial informartion
sigma <- expm::expm(darEsSalaam$adjacencyMatrix)
sigma <- diag(diag(sigma)^-0.5)\%*\% sigma \%*\%diag(diag(sigma)^-0.5)

##Not Run

#Fit BT model with ties
#darTiedModel <- BBTm.ties(n.objects = 452,
#                          outcome = darEsSalaam$comparisons$outcome,
#                          player1 = darEsSalaam$comparisons$subward1,
#                          player2 = darEsSalaam$comparisons$subward2,
#                          player.prior.var = sigma,
#                          hyperparameter = TRUE, rw.sd = 0.005)

#Get posterior means
#darTiedModel$lambda <- darTiedModel $lambda - colMeans(darTiedModel$lambda)
#lambda.mean <- rowMeans(darTiedModel$lambda)

#Generate trace plots
#plot(lambda.mean)
#plot(darTiedModel$theta[-c(1:100)], type = 'l')

}
