% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{speedyBBTm}
\alias{speedyBBTm}
\title{Standard Bayesian Bradley--Terry model}
\usage{
speedyBBTm(
  outcome = NULL,
  player1 = NULL,
  player2 = NULL,
  win.matrix = NULL,
  player.prior.var = NULL,
  lambda.initial = NULL,
  n.iter = 1000,
  hyperparameter = TRUE,
  chi = 0.01,
  psi = 0.01
)
}
\arguments{
\item{outcome}{vector of outcomes. 1 if player 2 is the winner,
0 if player 1 is the winner}

\item{player1}{vector of first players}

\item{player2}{vector of second players}

\item{win.matrix}{a win-loss matrix where the i,j th element is the number of
times object i beat object j}

\item{player.prior.var}{(optional) matrix specifying the prior covariance of
the player correlation parameters}

\item{lambda.initial}{(optional) vector containing the values of the
player correlation parameters for the first MCMC iteration}

\item{n.iter}{number of MCMC samples to be drawn}

\item{hyperparameter}{boolean indicating if inference should be performed
for the prior variance hyperparameter. If TRUE the prior variance
(main diagonal of the covariance matrix) must be set to 1.}

\item{chi}{rate parameter for the inverse-gamma prior distribution on the
hyperparameter}

\item{psi}{shape parameter for the inverse-gamma prior distribution on the
hyperparameter}
}
\value{
A data frame containing samples from the posterior distribution
}
\description{
This function uses MCMC to sample from the posterior distribution of the
standard Bradley--Terry model. Standard model means that there are no tied
comparisons and no player or comparison specific variables. This provides a
fast implementation of the standard model. A multivariate normal prior
distribution on the player quality parameters can be specified.
}
\details{
If \code{player.prior.var} is omitted, independent and identical
N(0, 1^2) prior distributions are placed on each object quality parameter.

If \code{lambda.initial} is ommitted, it is set to a vector of zeroes.
}
\examples{

########################################
## Forced Marriage in Nottinghamshire ##
########################################

#Construct covariance matrix based on spatial information
sigma <- expm::expm(forcedMarriage$adjacencyMatrix)
sigma <- diag(diag(sigma)^-0.5)\%*\% sigma \%*\%diag(diag(sigma)^-0.5)


##Not Run
#Fit model
#forcedMarriageModel <- speedyBBTm(outcome = rep(1, length(forcedMarriage$comparisons$win)),
#                                  player1 = forcedMarriage$comparisons$win,
#                                  player2 = forcedMarriage$comparisons$lost,
#                                 player.prior.var = sigma)

#Plot results
#plot(sort(forcedMarriageQualitySamples))

}
