% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotitem.cont}
\alias{plotitem.cont}
\alias{plotitem.disc}
\alias{plotgroup}
\title{Item level perspective plots or contour plots for spfa models}
\usage{
plotitem.cont(
  param,
  nquad = 21,
  npoints = 101,
  xlim = c(-2.5, 2.5),
  ylim = c(0, 1),
  normal = TRUE,
  FUN = NULL,
  plot = TRUE,
  type = "contour",
  ...
)

plotitem.disc(
  param,
  ncat,
  npoints = 101,
  xlim = c(-2.5, 2.5),
  normal = TRUE,
  FUN = NULL,
  plot = TRUE,
  col = 1:ncat,
  lty = rep(1, ncat),
  ...
)

plotgroup(
  param,
  nquad = 21,
  npoints = 101,
  lim = c(-2.5, 2.5),
  normal = TRUE,
  plot = TRUE,
  type = "contour",
  ...
)
}
\arguments{
\item{param}{parameter vector estimated from \code{\link{spfa}} model}

\item{nquad}{an integer value of number of quadrature points. Default is 21}

\item{npoints}{an integer value of number of x and y levels in the plot}

\item{xlim}{the x limits of the plot. Two numerical values indicating the lower and upper limits}

\item{ylim}{the y limits of the plot. Two numerical values indicating the lower and upper limits of the density. Note y is rescaled to a uniform [0,1] distribution.}

\item{normal}{a logical value \code{TRUE} or \code{FALSE} indicating which density is used to rescale y.}

\item{FUN}{a user supplied function to rescale.}

\item{plot}{a logical value \code{TRUE} or \code{FALSE} indicating whether the plot is visualized.}

\item{type}{the type of plot to be visualized. The default is the contour plot \code{\link{contour}}. It can also be changed to "\code{persp}" indicating perspective plots.}

\item{...}{additional arguments passed to \code{\link{contour}} and \code{\link{persp}}}

\item{ncat}{an integer value indicating the number of categories for the discrete item.}

\item{col}{color of the line.}

\item{lty}{line type}

\item{lim}{limit}
}
\value{
plots. Item level perspective and contour plot
}
\description{
For continuous response data use \code{plotitem.cont} whereas discrete response data use \code{plotitem.disc}. For joint continuous and discrete data, use \code{plotgroup}.
}
\examples{

# Contour plot of the first item 

plotitem.cont(spfa::spfa_example$par[[1]])
}
\seealso{
\code{\link{contour}} and \code{\link{persp}}
}
