% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapSpp.R
\name{heatmapSpp}
\alias{heatmapSpp}
\title{Visualise a distance matrix using a heatmap}
\usage{
heatmapSpp(
  distObj,
  sppVector,
  col = NULL,
  axisLabels = NULL,
  triangle = "both",
  showData = FALSE,
  dataRound = 3,
  dataCEX = 1
)
}
\arguments{
\item{distObj}{A matrix or object of class \code{dist}.}

\item{sppVector}{The species vector. See \code{\link{sppVector}}.}

\item{col}{A vector giving the colours for the heatmap.}

\item{axisLabels}{A character vector that provides the axis labels for the
heatmap. By default the species vector is used.}

\item{triangle}{Which triangle of the heatmap should be plotted. Possible
values of "both", "upper" and "lower". Default of "both".}

\item{showData}{Logical. Should the data be shown on the heatmap? Default of
FALSE.}

\item{dataRound}{The number of significant figures the printed data will
show. Default of 3.}

\item{dataCEX}{Size of text for printed data. Default of 1.}
}
\value{
Plots a heatmap of the distance matrix. Darker colours indicate
shorter distances, lighter colours indicate greater distances.
}
\description{
This function plots a heatmap of the distance matrix, with shorter distances
indicated by darker colours.
}
\details{
The default palette has been taken from the \code{colorspace} package.
}
\examples{

data(dolomedes)
doloDist <- ape::dist.dna(dolomedes, model = "raw")
doloSpp <- substr(dimnames(dolomedes)[[1]], 1, 5)
heatmapSpp(doloDist, doloSpp)
heatmapSpp(doloDist, doloSpp, axisLabels = dimnames(dolomedes)[[1]])

data(anoteropsis)
anoDist <- ape::dist.dna(anoteropsis, model = "raw")
anoSpp <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"), 
    function(x) paste(x[1], x[2], sep="_"))
heatmapSpp(anoDist, anoSpp)
heatmapSpp(anoDist, anoSpp, showData = TRUE)
heatmapSpp(anoDist, anoSpp, showData = TRUE, dataRound = 1, dataCEX = 0.4)
heatmapSpp(anoDist, anoSpp, triangle = "upper")
heatmapSpp(anoDist, anoSpp, triangle = "lower")
heatmapSpp(anoDist, anoSpp, triangle = "lower", showData = TRUE, dataRound = 1, dataCEX = 0.4)


}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
