% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spider-package.R
\docType{package}
\name{spider-package}
\alias{spider-package}
\alias{spider}
\title{Species Identity and Evolution in R}
\description{
Spider: SPecies IDentity and Evolution in R, is an R package implementing a
number of useful analyses for DNA barcoding studies and associated research
into species delimitation and speciation. Included are functions for
generating summary statistics from DNA barcode data, assessing specimen
identification efficacy, and for testing and optimising divergence threshold
limits. In terms of investigating evolutionary and taxonomic questions,
techniques for sliding window, population aggregate, and nucleotide
diagnostic analyses are also provided.
}
\details{
The complete list of functions can be displayed with
\code{library(help=spider)}.

More information, including a tutorial on the use of spider can be found at
\code{http://spider.r-forge.r-project.org}.

\tabular{ll}{ Package: \tab spider\cr Type: \tab Package\cr Version: \tab
1.4-2\cr Date: \tab 2017-05-13\cr License: \tab GPL\cr LazyLoad: \tab yes\cr
}

A few of the key functions provided by spider:

DNA barcoding: \code{\link{bestCloseMatch}}, \code{\link{nearNeighbour}},
\code{\link{threshID}}, \code{\link{threshOpt}}, \code{\link{heatmapSpp}}.

Sliding window: \code{\link{slidingWindow}}, \code{\link{slideAnalyses}},
\code{\link{slideBoxplots}}.

Nucleotide diagnostics: \code{\link{nucDiag}}, \code{\link{rnucDiag}}.

Morphological techniques: \code{\link{paa}}.
}
\references{
Brown S. D. J., Collins R. A., Boyer S., Lefort M.-C.,
Malumbres-Olarte J., Vink C. J., & Cruickshank R. H. 2012. SPIDER: an R
package for the analysis of species identity and evolution, with particular
reference to DNA barcoding. _Molecular Ecology Resources_ 12:562-565. doi:
10.1111/j.1755-0998.2011.03108.x
}
\seealso{
\code{\link[ape]{ape-package}}, \code{\link[pegas]{pegas-package}}.
}
\author{
Samuel Brown, Rupert Collins, Stephane Boyer, Marie-Caroline Lefort,
Jagoba Malumbres-Olarte, Cor Vink, Rob Cruickshank

Maintainer: Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{package}
