% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance_plotting.R
\name{plotImp}
\alias{plotImp}
\title{Create a barplot of relative variable importance scores.}
\usage{
plotImp(importance_vector, ...)
}
\arguments{
\item{importance_vector}{a named vector where the names are the variables and the vector stores the importances.}

\item{...}{additional arguments to plot, such as "main", "cex", etc.}
}
\description{
Given a named vector of variable importance measures, this function makes a barplot of the relative importances.
The importances are scaled to sum to 1. An appropriate input is one column of the output from
varImpY() or varImpCoeff().
}
\examples{
imp <- varImpCoeff(forest)[,3]
plotImp(imp, main="Standardized Variable Importance")
}
