% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_prediction.R
\name{predictYForest}
\alias{predictYForest}
\title{Predict responses for a testset using a splineforest.}
\usage{
predictYForest(forest, method = "oob", testdata = NULL)
}
\arguments{
\item{forest}{A model returned from splineForest()}

\item{method}{A string. Must be either "oob", "itb", or "all". Only relevant when testdata is NULL.
The default value is "oob". If "oob", predictions for a given data point are made only using
trees for which this data point was "out of the bag" (not in the random subsample).
 If "itb", predictions for a given data point are made using only the trees for which this datapoint
 was in the bag (in the random subsample). If "all", all trees are used for every datapoint.}

\item{testdata}{the Test data to make predictions for. If this is provided, then
all trees are used for all datapoints.}
}
\value{
A vector of predicted responses. The indices of the vector correspond to rows of the testdata.
}
\description{
Uses the forest to make predictions of responses for individuals. This method should only be used
on forests where forest$intercept=TRUE. If the testdata parameter is
null, makes predictions for each row of the training data. In this case, the methods parameter (which should
be set to "oob", "itb", or "all") determines the method used for prediction. If the testdata parameter is not
null, the methods parameter is ignored and all trees are used for the prediction of every datapoint.
}
\examples{
trainingSetPreds <- predictYForest(forest)
newData <- data.frame("AGE"=21, "WHITE" = 0, "BLACK"=1, "HISP"=0,
   "Num_sibs"=3, "HGC_MOTHER"=12, "HGC_FATHER"=12, "SEX"=1)
predictYForest(forest, testdata = newData)
}
