% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_variable_importance.R
\name{varImpCoeff}
\alias{varImpCoeff}
\title{Random Forest Variable Importance based on spline coefficients}
\usage{
varImpCoeff(forest, removeIntercept = TRUE, method = "oob")
}
\arguments{
\item{forest}{a random forest, generated from splineForest()}

\item{removeIntercept}{a boolean value, TRUE if you want to exclude the intercept in the calculations, FALSE otherwise.}

\item{method}{the method to be used. This must be one of "oob" (out of bag), "all", "itb" (in the bag).}
}
\value{
a matrix of variable importance metrics.
}
\description{
Returns the random forest variable importance based on the permutation accuracy measure, which is calculated as the difference in mean squared error between the original data and from randomly permuting the values of a variable.
}
\examples{
\donttest{
importanceMatrix <- varImpCoeff(forest, removeIntercept=TRUE)
}
}
