% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{apply_split_indexes_to_strata}
\alias{apply_split_indexes_to_strata}
\title{Split each element of a list of strata based on a list of indexes}
\usage{
apply_split_indexes_to_strata(strata, indexes)
}
\arguments{
\item{strata}{(list) list of strata to split}

\item{indexes}{(list) list of indexes, which can be generated via
\code{\link{get_split_indexes_from_strata}}}
}
\value{
(list) A list with two elements, containing the first and second
  split of \code{strata}.
}
\description{
Splits each element of \code{strata} into two parts based on a list of
indexes. For more information about splitting options, and an extensive list
of examples, see \code{\link{get_split_indexes_from_stratum}}.
}
\examples{
# Stratify a data frame, then split it odd-even
ds <- data.frame(condition = rep(c("a", "b"), each = 4), score = 1 : 8)
strata <- stratify(ds, ds$condition)
split_indexes <- get_split_indexes_from_strata(strata, method = "odd_even")
apply_split_indexes_to_strata(strata, split_indexes)
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
