% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ds_vpt}
\alias{ds_vpt}
\title{Example Visual Probe Task (VPT) Measurement Data in JASMIN1 Format}
\format{
An object of class \code{data.frame} with 19520 rows and 12 columns.
}
\usage{
ds_vpt
}
\description{
The JASMIN1 VPT distinguished between "test" stimuli, which are in some way assumed to be salient to the participant
and "control" stimuli, which are not. Test and control stimuli were presented in pairs, with
one left and one right, followed by a probe that was an arrow pointing up or down. Participants needed
to indicate whether the arrow pointed up or down. Upon a correct response the next trial started and
upon an incorrect response the current trial was repeated. Only the first response to a new trial was logged.
This particular VPT was part of the pre-measurement
of a cognitive bias modification study. The "test" stimuli were alcoholic beverages and the "control" stimuli
were non-alcoholic beverages, selected from the Amsterdam Beverage Picture Set
(Pronk et al., 2015) <\doi{10.1111/acer.12853}>.
The dataset contains one row per trial.
This dataset was graciously provided by Marilisa Boffo.
}
\details{
Overview of columns:
\itemize{
  \item UserID. Identifies participants
  \item patt. Probe-at-test. If "yes", the probe was positioned at the test stimulus. If "no", the probe was positioned at the control stimulus.
  \item phor. Probe horizontal position. Values: "left" or "right"
  \item thor. Test horizontal position. Values: "left" or "right"
  \item keep. If "yes" the probe was superimposed on the stimuli. If "no" the probe replaced the stimuli.
  \item pdir. Probe direction. Values: "up" or "down"
  \item stim. Stimulus
  \item response. Response; 1 = correct, 2 = incorrect, 3 and NA = timeout (no response in 5000 ms), 4 = invalid key
  \item rt. Response time in milliseconds
  \item block. Counts blocks, starting at zero
  \item trial. Counts trials in blocks, starting at zero
  \item block_type. Type of block: "assess" for assessment trials with salient stimuli
}
}
\keyword{datasets}
