% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow.R
\name{check_users_following}
\alias{check_users_following}
\title{Check if Users Follow a Playlist}
\usage{
check_users_following(
  playlist_id,
  ids,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{playlist_id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} of the playlist.}

\item{ids}{Required. \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify User IDs}; the ids of the users that you want to check to see if they follow the playlist. Maximum: 5 ids.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. \cr
Following a playlist can be done publicly or privately. Checking if a user publicly follows a playlist doesn’t require any scopes; if the user is publicly following the playlist, this endpoint returns \code{TRUE}. \cr
Checking if the user is privately following a playlist is only possible for the current user when that user has granted access to the \code{playlist-read-private} scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}
}
\value{
A data frame containing three columns,\cr
\code{"user_id"} for the particular users, \cr
\code{"playlist_id"} for the particular playlists, \cr
\code{"is_following"} as a logical, boolean variable.
}
\description{
Check if particular users are following a particular playlist.
}
\seealso{
Other playlist functions: 
\code{\link{add_tracks_to_playlist}()},
\code{\link{change_playlist_details}()},
\code{\link{create_playlist}()},
\code{\link{get_my_playlists}()},
\code{\link{get_playlist}()},
\code{\link{get_user_playlists}()},
\code{\link{remove_tracks_from_playlist}()},
\code{\link{tidy}()}
}
\concept{playlist functions}
