% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlrunners.R
\name{run_files}
\alias{run_files}
\alias{runfiles}
\title{Read, prepare and execute .SQL files}
\usage{
run_files(filenames, ..., include_params = FALSE)

runfiles(filenames, ..., include_params = FALSE)
}
\arguments{
\item{filenames}{name, or vector of names, of file(s) to be executed}

\item{...}{Arguments to be passed to \code{\link[=run_queries]{run_queries()}}, \code{\link[=prepare_sql]{prepare_sql()}}, or \code{\link[=read_sql]{read_sql()}}}

\item{include_params}{\code{TRUE} or \code{FALSE}. Should the parameters be
included in the output?}
}
\value{
A list of results of sql queries found in files
}
\description{
Accepts a character vector of SQL file names and attempts to execute the
queries in each one.
}
\details{
If no default connection is supplied via \code{default.conn} and no
connections have been configured using \code{connect()}, an attempt will be made
to configure connections via \code{connect()} using the configuration search
path. If no database connections are available after this attempt, an error
will be raised. See \code{vignette("connections")} for details about the
configuration search path.

\code{\link[=run_files]{run_files()}} calls \code{\link[=read_sql]{read_sql()}} on each file, and \code{\link[=prepare_sql]{prepare_sql()}} on the
queries read from those files. Prepared queries are executed with \code{\link[=run_queries]{run_queries()}}. The
behaviour of those functions can be controlled by passing the relevant
parameters to \code{\link[=run_files]{run_files()}} as the \code{...} argument.

\code{\link[=run_files]{run_files()}} also enables control of the arguments accepted by \code{\link[=run_queries]{run_queries()}} on
a per-query basis, by interpreting comments in SQL files as described
for \code{read_sql()}. Interpreted comments precede the sql query to which they
refer. Each interpretable comment must be on a line by itself and take the
form:

\if{html}{\out{<div class="sourceCode sql">}}\preformatted{-- keyword = value
}\if{html}{\out{</div>}}

Keywords and possible values for interpretable comments are:

\describe{
\item{qname}{A name for this query}
\item{quotesql}{"yes" or "no" - should interpolated characters be quoted?}
\item{interpolate}{"yes" or "no" - should sql be interpolated?}
\item{execmethod}{One of "get", "execute", "sendq", "sends" or "spatial" -
which method should be used to execute the query? "get" means
\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}; "execute" means \code{\link[DBI:dbExecute]{DBI::dbExecute()}}; "sendq" means
\code{DBI::dbSendQuery}; "sends" means \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}; "spatial"
means \code{\link[sf:st_read]{sf::st_read()}}.}
\item{geometry}{The name of a spatial column. Ignored if \code{execmethod} is not 'spatial'}
\item{conn_name}{The name of a connection to execute this query against}
}

All interpreted comments except \code{qname} are cascaded \emph{within their file},
meaning that if you want to use the same values throughout, you need only set
them for the first query. See \code{read_sql()} for details.
}
\examples{
library(sqlhelper)

config_filename <- system.file("examples/sqlhelper_db_conf.yml",
                package="sqlhelper")

readLines( config_filename ) |> writeLines()

connect(
    config_filename,
    exclusive=TRUE)

DBI::dbWriteTable( default_conn(), "iris", iris)

sf::st_write(spData::congruent, default_conn(), "congruent")
sf::st_write(spData::incongruent, live_connection("pool_sqlite"), "incongruent")

run_files_ex1 <- system.file("examples/run_files_ex1.sql", package="sqlhelper")
readLines( run_files_ex1 ) |> writeLines()

run_files_ex2 <- system.file("examples/run_files_ex2.sql", package="sqlhelper")
readLines( run_files_ex2 ) |> writeLines()

n_longest_petals <- 5
results <- run_files( c( run_files_ex1, run_files_ex2 ) )

names(results)

results$how_many_irises

results$n_longest_setosa_petal_lengths

plot(results$get_congruent, border = "orange")
plot(results$get_incongruent, border = "blue", add=TRUE)

}
\seealso{
\code{\link[=read_sql]{read_sql()}}, \code{\link[=prepare_sql]{prepare_sql()}}

Other SQL runners: 
\code{\link{run_queries}()}
}
\concept{SQL runners}
