% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtSelectAll.R
\name{StmtSelectAll}
\alias{StmtSelectAll}
\title{SELECT * statement.}
\description{
SELECT * statement.

SELECT * statement.
}
\details{
This class represents a SQL SELECT * statement. It can be used to select
all fields from a table, with optional \code{distinct} keyword to remove duplicate
results.
}
\examples{
# Create a SELECT * statement:
select_all <- StmtSelectAll$new()

# Use the created SELECT * statement inside a SELECT query:
query <- QuerySelect$new(select = select_all,
                         from = StmtFrom$new("books"))

# Create a SELECT DISTINCT * statement:
select_distinct_all <- StmtSelectAll$new(distinct = TRUE)

}
\section{Super classes}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{\link[sqlq:StmtSelect]{sqlq::StmtSelect}} -> \code{StmtSelectAll}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtSelectAll-new}{\code{StmtSelectAll$new()}}
\item \href{#method-StmtSelectAll-getTokens}{\code{StmtSelectAll$getTokens()}}
\item \href{#method-StmtSelectAll-clone}{\code{StmtSelectAll$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectAll-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectAll-new}{}}}
\subsection{Method \code{new()}}{
Initializer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectAll$new(distinct = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distinct}}{Set to TRUE enable \code{distinct} keyword and remove
duplicate results.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectAll-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectAll-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectAll$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSelectAll-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSelectAll-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSelectAll$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
