% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtWhere.R
\name{StmtWhere}
\alias{StmtWhere}
\title{SQL WHERE statement.}
\description{
SQL WHERE statement.

SQL WHERE statement.
}
\details{
This class represents a SQL WHERE statement, used to filter results in
SELECT, UPDATE, and DELETE statements.
}
\examples{
# Create a WHERE statement with a simple expression:
expr <- ExprBinOp$new(ExprValue$new("age"), ">=", ExprValue$new(18))
where <- StmtWhere$new(expr)

# Use the created WHERE statement inside a SELECT query:
query <- QuerySelect$new(StmtSelectAll$new(),
                         from = StmtFrom$new("users"))
query$add(where)

}
\section{Super class}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{StmtWhere}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtWhere-new}{\code{StmtWhere$new()}}
\item \href{#method-StmtWhere-getTokens}{\code{StmtWhere$getTokens()}}
\item \href{#method-StmtWhere-clone}{\code{StmtWhere$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtWhere-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtWhere-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtWhere$new(expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{The expression to evaluate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtWhere-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtWhere-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtWhere$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtWhere-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtWhere-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtWhere$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
