testthat::context("Create Table Query class")

testthat::test_that("We can create a CREATE TABLE query with the factory", {
  fields_def <- list(ExprFieldDef$new('id', 'integer', primary=TRUE),
                     ExprFieldDef$new('title', 'varchar(200)', nullable=FALSE),
                     ExprFieldDef$new('author', 'varchar(80)', nullable=FALSE))
  x <- make_create_table(tabl = 'books', fields_def = fields_def)
  testthat::expect_equal(x$toString(),
                         paste("CREATE TABLE books",
                               "(id INTEGER PRIMARY KEY,",
                               '"title" VARCHAR(200) NOT NULL,',
                               "author VARCHAR(80) NOT NULL);"))
})
