% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{get_heatmap}
\alias{get_heatmap}
\title{Plotting a heatmap with subtype labels.}
\usage{
get_heatmap(
  Path_ES,
  Path_name,
  samp_class,
  scale = "row",
  cluster_rows = TRUE,
  cluster_cols = FALSE,
  show_rownames = TRUE,
  show_colnames = FALSE,
  fontsize = 8,
  annotation_legend = TRUE,
  annotation_names_row = TRUE,
  annotation_names_col = TRUE
)
}
\arguments{
\item{Path_ES}{Single-sample mutation-based pathway enrichment score profiles.The file can be generated by the function `get_RWR_ES`.}

\item{Path_name}{The names of the pathways that you want to show in the heatmap.The Path_name must be included in the row names of the Path_ES .}

\item{samp_class}{A vector containing information about the subtype labels.The vector can be generated by the function `get_samp_class`.}

\item{scale}{character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row", "column" and "none".}

\item{cluster_rows}{Boolean values determining if rows should be clustered or hclust object.}

\item{cluster_cols}{Boolean values determining if columns should be clustered or hclust object.}

\item{show_rownames}{Boolean specifying if row names are be shown.}

\item{show_colnames}{Boolean specifying if column names are be shown.}

\item{fontsize}{base font size for the plot.}

\item{annotation_legend}{Boolean value showing if the legend for annotation tracks should be drawn .}

\item{annotation_names_row}{Boolean value showing if the names for row annotation tracks should be drawn.}

\item{annotation_names_col}{Boolean value showing if the names for column annotation tracks should be drawn.}
}
\value{
A heatmap
}
\description{
The function `get_heatmap` is used to plot a heatmap with subtype labels.
}
\examples{
#load the data
data(Path_ES,sample_class,Path_Name)
#perform the function `get_heatmap`.
get_heatmap(Path_ES,Path_name=Path_Name,samp_class=sample_class)
}
