% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origin_destination.R
\name{make_passenger_od}
\alias{make_passenger_od}
\title{Summaries a passenger volume}
\usage{
make_passenger_od(
  passenger,
  stations,
  depart,
  arrive,
  location,
  value,
  .all = FALSE
)
}
\arguments{
\item{passenger}{passenger data}

\item{stations}{data.frame which set of stopping points recorded in order of
stopping.}

\item{depart}{Column name of a stop.}

\item{arrive}{Give the name of the column indicating the next stop at the
target stop.}

\item{location}{Name of the variable to use for the join, indicating
its location.}

\item{value}{origin-destination value name}

\item{.all}{Make a join that contains rows of two datasets.
The default value is \emph{FALSE}.}
}
\description{
Summaries a passenger volume
}
\examples{
jreast_jt_od \%>\%
  make_passenger_od(jreast_jt,
                    depart = departure_st_code,
                    arrive_st_code,
                    location = st_code,
                    value = volume) \%>\%
 dplyr::left_join(jreast_jt \%>\%
                    dplyr::select(arrive_st_code = st_code,
                                  next_st_name = st_name),
                   by = "arrive_st_code")
}
