% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{eem_export}
\alias{eem_export}
\title{Export all samples of an eem_list}
\usage{
eem_export(file, format = c("csv", "mat"), ...)
}
\arguments{
\item{file}{path to directory (csv format) or file (Matlab format)}

\item{format}{either "csv" or "mat" to specify export format}

\item{...}{one or more eem_list objects}
}
\value{
0 on successful export
}
\description{
Export all samples of an eem_list
}
\examples{
# create temporary directory to write out
file <- paste0(tempdir(),"/eem_export/")
dir.create(file)

# run eem_export to write one csv file for each sample
eem_export(file, format = "csv", eem_list)

# show content of output directory
dir(file)

}
