% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggeem_overlay}
\alias{ggeem_overlay}
\title{Add layers of scatter bands, molecular regions and common peaks to EEM plots}
\usage{
ggeem_overlay(
  plot,
  scatter = rep(TRUE, 4),
  regions = TRUE,
  peakloc = TRUE,
  limit = TRUE,
  ...
)
}
\arguments{
\item{plot}{the ggplot where the layers are added}

\item{scatter}{logical vector of size 4 stating the scatter bands to be marked. The order is Raman 1, Raman 2, Rayleigh 1, Rayleigh 2.}

\item{regions}{logical, whether molecular regions are marked}

\item{peakloc}{logical, whether common EEM peaks are marked}

\item{limit}{logical, whether the plot is limited to the original EEM}

\item{...}{additional arguments passed to geom_eemregions(), geom_eemscatter() and geom_eempeakloc().}
}
\value{
an altered ggplot2
}
\description{
This function is a wrapper for \code{\link[staRdom]{geom_eemregions}}, \code{\link[staRdom]{geom_eempeakloc}}, \code{\link[staRdom]{geom_eemscatter}} and can limit the plot extend to the area of the original EEM.
Therefore, it is not added using '+' but the plot has to be supplied as an argument.
}
\examples{
require(tidyr)

eem_list \%>\%
 eem_extract(eem_names((eem_list))[1], keep = TRUE) \%>\%
 ggeem() \%>\%
 ggeem_overlay()
}
