% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_catboost.R
\name{catboost_load_pool}
\alias{catboost_load_pool}
\title{Create a dataset}
\usage{
catboost_load_pool(data, label = NULL, ...)
}
\arguments{
\item{data}{Predictors.}

\item{label}{Labels.}

\item{...}{Additional parameters.}
}
\value{
A \code{catboost.Pool} object.
}
\description{
Create a dataset
}
\examples{
\dontshow{if (is_installed_catboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 100,
  p = 10,
  rho = 0.6,
  coef = rnorm(5, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

catboost_load_pool(data = sim_data$x.tr, label = sim_data$y.tr)
catboost_load_pool(data = sim_data$x.tr, label = NULL)
catboost_load_pool(data = sim_data$x.te, label = NULL)
\dontshow{\}) # examplesIf}
}
