% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_bhcr.R
\name{stages_bhcr}
\alias{stages_bhcr}
\title{Backward random hill-climbing}
\usage{
stages_bhcr(
  object,
  score = function(x) {
     return(-BIC(x))
 },
  max_iter = 100,
  trace = 0
)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{score}{the score function to be maximized.}

\item{max_iter}{the maximum number of iteration.}

\item{trace}{if >0 increasingly amount of info
is printed (via \code{message}).}
}
\value{
an object of class \code{sevt}.
}
\description{
Randomly try to join stages.
This is a pretty-useless function, used for comparisons.
}
\details{
At each iteration a variable and
two of its stages are randomly selected.
If joining the stages increases the score, the model is
updated. The procedure is repeated until the
number of iterations reaches \code{max_iter}.
}
\examples{
DD <- generate_xor_dataset(p = 4, n = 100)
model <- stages_bhcr(full(DD), trace = 2)
summary(model)
}
