% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized-class.R
\name{standardized-class}
\alias{standardized-class}
\title{Class \code{standardized} containing regression variables in a standardized space.}
\description{
The \code{\link{standardize}} function returns a list of class
\code{standardized}, which has a \code{print} method,
and which can additionally be used to place new data into the same
standardized space as the data passed in the call to \code{\link{standardize}}
using the \code{\link[=predict.standardized]{predict}} function.
The \code{standardized} list contains the following elements.
}
\details{
\describe{
  \item{call}{The call to \code{\link{standardize}} which created the
    object.}

  \item{scale}{The \code{scale} argument to \code{\link{standardize}}.}

  \item{formula}{The regression formula in standardized space (with new
    names) which can be used along with the \code{data} element to fit
    regressions.  It has an attribute \code{standardized.scale} which is the
    same as the \code{scale} element of the object (this allows users and
    package developers to write regression-fitting functions which can tell
    if the input is from a \code{standardized} object).}

  \item{family}{The regression family.}

  \item{data}{A data frame containing the regression variables in a
    standardized space (renamed to have valid variable names corresponding
    to those in the \code{formula} element).}

  \item{offset}{The offset passed through the \code{offset} argument to
    \code{\link{standardize}} (scaled if \code{family = gaussian}), or
    \code{NULL} if the \code{offset} argument was not used.}

  \item{pred}{A list containing unevaluated calls which allow the
    \code{\link[=predict.standardized]{predict}} method to work.}

  \item{variables}{A data frame with the name of the original variable,
    the corresponding name in the standardized data frame and formula,
    and the class of the variable in the standardized data frame.}

  \item{contrasts}{A named list of contrasts for all factors included as
    predictors, or \code{NULL} if no predictors are factors.}

  \item{groups}{A named list of levels for random effects grouping factors,
    or \code{NULL} if there are no random effects.}
}

In the \code{variables} data frame, the \code{Variable} column contains the
name of the variable in the original formula passed to \code{\link{standardize}}.
The \code{Standardized Name} column contains the name of the variable in the standardized
formula and data frame. The original variable name is altered such that the
original name is still recoverable but is also a valid variable name for
regressions run using the \code{formula} and \code{data} elements of the
\code{standardized} object.  For example, \code{exp(x)} would become
\code{exp_x} and \code{log(x + 1)} would become \code{log_x.p.1}.  If
the indicator function is used, this can lead to a long and possibly
difficult to interpret name; e.g. \code{I(x1 > 0 & x2 < 0)} would become
\code{I_x1.g.0.a.x2.l.0}. In such cases, it is better to create the variable
explicitly in the data frame and give it a meaningful name; in this case,
something like \code{mydata$x1Pos_x2Neg <- mydata$x1 > 0 & mydata$x2 < 0},
and then use \code{x1Pos_x2Neg} in the call to \code{\link{standardize}}.
The \code{Class} column in the \code{variables} data frame takes the
following values (except for non-gaussian responses, which are left
unaltered, and so may have a different class; the class for the response is
always preceded by \code{response.}).

\describe{
  \item{numeric}{A numeric vector.}

  \item{poly}{A numeric matrix resulting from a call to
    \code{\link[stats]{poly}}.}

  \item{scaledby}{A numeric vector resulting from a call to
    \code{\link{scale_by}}.}

  \item{scaledby.poly}{A numeric matrix resulting from a call to
    \code{\link[stats]{poly}} nested within a call to
    \code{\link{scale_by}}.}

  \item{factor}{An unordered factor.}

  \item{ordered}{An ordered factor.}

  \item{group}{A random effects grouping factor.}

  \item{offset}{If the offset function was used within the formula passed to
    \code{\link{standardize}}, then the variable is numeric and labeled as
    \code{offset}.  The \code{formula} element of the \code{standardize}
    object contains offset calls to ensure regression fitting functions use
    them properly.  If the \code{offset} argument was used in the call to
    \code{\link{standardize}} (rather than putting offset calls in the
    formula), then the offset is not in the \code{variables} data frame (it
    is in the \code{offset} element of the \code{standardized} object).}
}

The \code{standardized} object has a printing method which displays the call,
formula, and variable frame along with an explanation of the
standardization.  The \code{\link{is.standardized}} function returns
\code{TRUE} if an object is the result of a call to \code{\link{standardize}}
and \code{FALSE} otherwise.  The \code{\link[=predict.standardized]{predict}}
method places new data into the same standardized space as the data
passed to the original \code{\link{standardize}} call.
}
\author{
Christopher D. Eager <eager.stats@gmail.com>
}
