% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_pdf.R
\name{combine_pdf}
\alias{combine_pdf}
\title{Combine multiple PDF files}
\usage{
combine_pdf(vec_input, output = "output.pdf", start_pages = NA, end_pages = NA)
}
\arguments{
\item{vec_input}{Vector with paths of PDF files to be combined.}

\item{output}{PDF file path result of the combination.}

\item{start_pages}{Vector with the initial pages of each file. If \code{NA},
the default, will be considered the first page.}

\item{end_pages}{Vector with the final pages of each file. If \code{NA}, the
default, will be considered the last page.}
}
\value{
In the path informed in \code{output}, the PDF file resulting from the combination
of multiple files passed to \code{vec_output} will be saved.
}
\description{
Combine multiple PDF files by delimiting the sequences of pages in each file.
}
\examples{


if (requireNamespace("lattice", quietly = TRUE)) {
dir <- tempfile()
dir.create(dir)
for(i in 1:2) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(lattice::xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}

output <- tempfile(fileext = '.pdf')
combine_pdf(
   vec_input =
      file.path(dir, paste("plot", 1:2, ".pdf", sep = "")),
   output = output,
   start_pages = c(NA, NA),
   end_pages = c(NA, NA)
 )
 }
}
