% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.stdmean.ws}
\alias{ci.2x2.stdmean.ws}
\title{Computes confidence intervals of standardized effects in a 2x2
within-subjects design}
\usage{
ci.2x2.stdmean.ws(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimated standardized effect
\item adj Estimate - bias adjusted standardized effect estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for standardized AB interaction effect, main
effect of A, main effect of B, simple main effects of A, and simple main
effects of B in a 2x2 within-subjects factorial design. Equality of
population variances is not assumed. A square root unweigthed average
variance standardizer is used.
}
\examples{
y11 <- c(21, 39, 32, 29, 27, 17, 27, 21, 28, 17, 12, 27)
y12 <- c(20, 36, 33, 27, 28, 14, 30, 20, 27, 15, 11, 22)
y21 <- c(21, 36, 30, 27, 28, 15, 27, 18, 29, 16, 11, 22)
y22 <- c(18, 34, 29, 28, 28, 17, 27, 21, 26, 16, 14, 23)
ci.2x2.stdmean.ws(.05, y11, y12, y21, y22)

# Should return:
#             Estimate  adj Estimate         SE           LL        UL
# AB:       0.17248839    0.16446123 0.13654635 -0.095137544 0.4401143
# A:        0.10924265    0.10415878 0.05752822 -0.003510596 0.2219959
# B:        0.07474497    0.07126653 0.05920554 -0.041295751 0.1907857
# A at b1:  0.19548684    0.18638939 0.08460680  0.029660560 0.3613131
# A at b2:  0.02299845    0.02192816 0.09371838 -0.160686202 0.2066831
# B at a1:  0.16098916    0.15349715 0.09457347 -0.024371434 0.3463498
# B at a2: -0.01149923   -0.01096408 0.08595873 -0.179975237 0.1569768


}
\references{
\insertRef{Bonett2008}{statpsych}
}
