% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generator}
\alias{generator}
\title{Generation of multivariate normal data.}
\usage{
generator(n , mean = 0, sigma = 1, coefvar = NULL,
    sigmaSup = NULL, dec = 2)
}
\arguments{
\item{n}{vector size of samples.}

\item{mean}{vector of means.}

\item{sigma}{vector of standard deviations or covariance/correlation matrix.}

\item{coefvar}{an optional vector of coefficients of variation.}

\item{sigmaSup}{an optional vector of standard deviations if sigma is a correlation matrix.}

\item{dec}{number of decimals for observations.}
}
\value{
List containing the following components for independent (with the same length) and dependent samples:

\itemize{

 \item \code{Samples}: a data frame containing the samples created.


 \item Test normality test for the data (\code{shapiro.test()} for n <= 50 and \code{lillie.test()} in other case).

}

List containing the following components for independent samples with different lengths:

\itemize{

 \item \code{X_i} sample number i.

}
}
\description{
This function generates univariate and multivariate normal data. It allows simulating correlated and independent samples. Moreover, normality tests and numeric informations are provided.
}
\details{
If \code{mean} or \code{sigma} are not specified it's assumed the default values of \code{0} and \code{1}.

    If \code{coefvar} (= \code{sigma}/\code{mean}) is specified, function omits \code{sigma} and \code{sigmaSup}. It's assumed that independent samples are desired.

    Number of samples are choosen by taken the longest parameter (\code{n}, \code{mean}, \code{sigma}, \code{coefvar}). Therefore, function \code{rep} is used. Pay attention if vectors don't have same length!

    If \code{sigma} is a vector, samples are independent. In other case (\code{sigma} is a matrix), samples are dependent (following information meanst be taken into account: if \code{sigma} is a correlation matrix, \code{sigmaSup} is required).
}
\examples{
generator(4,0,2)

sigma <- matrix(c(1,0.8,0.8,1),nrow = 2, byrow = 2)
d <- generator(4,mean = c(1,2),sigma, sigmaSup = 1)

generator(10,1,coefvar = c(0.3,0.5))

generator(c(10,11,10),c(1,2),coefvar = c(0.3,0.5))


}
