% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sites_ranking_distribution.R
\name{ssar_sites_ranking_dist}
\alias{ssar_sites_ranking_dist}
\title{Get Sites Ranking Distribution}
\usage{
ssar_sites_ranking_dist(
  siteid = NULL,
  fromdate = as.character(Sys.Date() - 31),
  todate = as.character(Sys.Date() - 1),
  subdomain = Sys.getenv("SSAR_SUBDOMAIN"),
  apikey = Sys.getenv("SSAR_APIKEY")
)
}
\arguments{
\item{siteid}{\emph{Required} The site id.}

\item{fromdate}{\emph{Required} Character string in the 'YYYY-MM-DD' format. Default is -31 days from today since the maximum date range can be no greater than 31 days.}

\item{todate}{\emph{Required} Character string in the 'YYYY-MM-DD' format. Default is yesterday.}

\item{subdomain}{The account subdomain}

\item{apikey}{The api key from the account}
}
\value{
A table with Google, GoogleBaseRank, and Bing ranking distributions by date
}
\description{
This function returns all ranking distribution records for Google and Bing for a site with the specified id. The maximum date range can be no greater than 31 days.
}
\examples{
 
\dontrun{
ssar_sites_ranking_dist(siteid = {site_id}, #replace is your site id
                       fromdate = '2021-04-01',
                       todate = '2021-05-31')
}

}
