% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_int_ish.R
\name{are_int_ish}
\alias{are_int_ish}
\alias{is_int_ish}
\alias{are_int_ish.character}
\alias{are_int_ish.factor}
\alias{are_int_ish.default}
\title{Check if an object can be safely coerced to integer}
\usage{
are_int_ish(x, ...)

is_int_ish(x, ...)

\method{are_int_ish}{character}(x, ..., coerce_character = TRUE)

\method{are_int_ish}{factor}(x, ..., coerce_factor = TRUE)

\method{are_int_ish}{default}(x, ..., depth = 1)
}
\arguments{
\item{x}{The object to check.}

\item{...}{Arguments passed to methods.}

\item{coerce_character}{\verb{(length-1 logical)} Should character vectors such as
"1" and "2.0" be considered numeric-ish?}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{depth}{\verb{(length-1 integer)} Current recursion depth. Do not manually
set this parameter.}
}
\value{
\code{are_int_ish()} returns a logical vector with the same length as the
input. \code{is_int_ish()} returns a \verb{length-1 logical} (\code{TRUE} or \code{FALSE}) for
the entire vector.
}
\description{
\code{are_int_ish()} is a vectorized predicate function that checks
whether each element of its input can be safely coerced to an integer
vector.

\code{is_int_ish()} is a scalar predicate function that checks if all elements
of its input can be safely coerced to an integer vector.
}
\examples{
are_int_ish(1:4)
is_int_ish(1:4)

are_int_ish(c(1.0, 2.0, 3.00000))
is_int_ish(c(1.0, 2.0, 3.00000))

are_int_ish(c("1.0", "2.0", "3.00000"))
is_int_ish(c("1.0", "2.0", "3.00000"))

are_int_ish(c(1, 2.2, NA))
is_int_ish(c(1, 2.2, NA))

are_int_ish(c("1", "1.0", "1.1", "a"))
is_int_ish(c("1", "1.0", "1.1", "a"))

are_int_ish(factor(c("1", "a")))
is_int_ish(factor(c("1", "a")))
}
