% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_null.R
\name{.to_null}
\alias{.to_null}
\title{Ensure an argument is NULL}
\usage{
.to_null(x, allow_null = TRUE, x_arg = caller_arg(x), call = caller_env())
}
\arguments{
\item{x}{The argument to stabilize.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}
}
\value{
\code{NULL} or an error.
}
\description{
If \code{allow_null} is \code{TRUE}, coerce \code{x} to \code{NULL}. Otherwise throw an
informative error.
}
\keyword{internal}
