% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_scores_scoring}
\alias{normalize_scores_scoring}
\title{Normalize scores using ScoringTables}
\usage{
normalize_scores_scoring(
  data,
  vars,
  ...,
  retain = FALSE,
  group_col = NULL,
  .dots = list()
)
}
\arguments{
\item{data}{data.frame containing raw scores}

\item{vars}{names of columns to normalize. Length of vars
need to be the same as number of tables provided to either \code{...} or \code{.dots}}

\item{...}{\code{ScoringTable} objects to be used for normalization. They should
be provided in the same order as \code{vars}}

\item{retain}{either boolean: \code{TRUE} if all columns in the \code{data} are to be
retained, \code{FALSE} if none; or names of columns to be retained}

\item{group_col}{name of the column for name of the group each
observation was qualified into. If left as default \code{NULL}, they won't be returned.
Ignored if no conditions are available}

\item{.dots}{\code{ScoringTable} objects provided as a list, instead of individually in \code{...}.}
}
\value{
data.frame with normalized scores
}
\description{
Normalize scores using either \code{ScoringTable} objects for one or
more variables. Given data.frame should also contain columns used in
\code{GroupingConditions} attached to the table (if any)
}
\examples{
# Scoring table to export / import #
suppressMessages(
  Consc_ST <- 
    GroupedFrequencyTable(
      data = IPIP_NEO_300,
      conditions = GroupConditions("Sex", "M" ~ sex == "M", "F" ~ sex == "F"), 
      var = "C") |>
    GroupedScoreTable(scale = STEN) |>
    to_ScoringTable(min_raw = 60, max_raw = 300)
)

# normalize scores
Consc_norm <- 
  normalize_scores_scoring(
    data = IPIP_NEO_300,
    vars = "C",
    Consc_ST,
    group_col = "Group"
  )

str(Consc_norm)
}
\seealso{
Other score-normalization functions: 
\code{\link{normalize_scores_df}()},
\code{\link{normalize_scores_grouped}()},
\code{\link{normalize_score}()}
}
\concept{score-normalization functions}
