% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_refs.R
\name{filter_refs}
\alias{filter_refs}
\title{Filter a Data Frame of Citations and Return the Entries as a Character}
\usage{
filter_refs(bibdat, criteria, type = "bibtexkey")
}
\arguments{
\item{bibdat}{a data frame of citations, like the one created by the
\pkg{bib2df} package}

\item{criteria}{criteria, specified as a character vector, by which to
filter the data frame of citations}

\item{type}{the particular type of citation entry on which to filter.
Defaults to "bibtexkey" (which filters based on a column of unique citation
keys). When \code{type == "year"}, the function filters on a character vector of
years.}
}
\value{
\code{filter_refs()} takes a data frame of citations, like the one
created by the \pkg{bib2df} package, and returns a character vector
(amounting to a valid \code{.bib} entry) of citations the user wants. This can
then be easily passed to the \code{print_refs()} function also included in this
package.
}
\description{
\code{filter_refs()} is a convenience function I wrote for
filtering a data frame of citations returning the entries as a valid
\code{.bib} entry (as a character vector). I wrote this for more easily passing
on citations to the \code{print_refs()} function also included in this package.
}
\details{
\code{filter_refs()} assumes some familiarity with \code{BibTeX}, \code{.bib}
entries, and depends on the \pkg{bib2df} package.
}
\examples{
# Based on `stevepubs` configuration, filter on `BIBTEXKEY` where
# the citation key matches one of these.
filter_refs(stevepubs, c("miller2017etst", "miller2017etjc", "miller2013tdpi"))

# Based on `stevepubs` configuration, filter on `YEAR` where
# the publication year is 2017, 2018, 2019, 2020, or 2021.
filter_refs(stevepubs, c(2017:2021), type = "year")
}
