% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fine-tune.R
\name{adj_font_size}
\alias{adj_font_size}
\title{Miscellaneous functions for fine-tuning \pkg{ggplot2} plots}
\usage{
adj_font_size(x, ...)
}
\arguments{
\item{x}{a numeric vector that will adjust the size of all fonts on the plot. Can take decimals and negative numbers.}

\item{...}{optional, called for side effects}
}
\value{
\code{adj_font_size()} takes a plot made in \pkg{ggplot2} and changes
the font size by some number requested by the user. It returns a plot with
bigger or smaller fonts, per the user's request.
}
\description{
These are assorted functions that will fine-tune various things
in a \pkg{ggplot2} plot.
}
\details{
\code{adj_font_size()} is a simple wrapper for some basic
\pkg{ggplot2} code that will allow you to adjust the font size on the plot by
some number.

Right now, \code{adj_font_size()} assumes you are using \code{theme_steve()}
because the font sizes initialized in the function are defaults from the theme.
}
\examples{

library(ggplot2)

example_plot(type = "scatter") + adj_font_size(-2)

example_plot(type = "scatter") + adj_font_size(2)

}
\author{
Steven V. Miller
}
