% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectTable.R
\name{effectTable}
\alias{effectTable}
\title{Create a parameter table}
\usage{
effectTable(model)
}
\arguments{
\item{model}{An object with the model description for the cross-sectional model in lavaan syntax}
}
\value{
A list with information on the cross-lagged paths and the residual covariances. The cross-lagged effect table has
information on which cross-lagged effects to estimate and which to constrain. Each
row represents one effect and specifies which variable is the predictor and outcome of the effect.
The name column contains information on either the name of the estimated effect (e.g., CLxy)
or what value the unestimated effect should be constrained to (e.g., .3).
The residual covariance list has the lavaan syntax to specify that specific residuals should be allowed to
covary, and a table with information on which variables should have covarying residuals and what the name of
that residual covariance parameter should be.
}
\description{
Create a parameter table
}
\examples{

#estimate effect from X to Y
#constrain effect from Y to X to .3
#allow X and Y's residuals to covary
model <- c('Y ~  X
            X ~ .3 * Y
            X ~~ Y')

effectTable(model)
}
