% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_trend}
\alias{plot_trend}
\title{Trend Diagnostic Plot for an stlplus Object}
\usage{
plot_trend(x, xlab = "Time", ylab = "Trend", span = 0.3, type = c("p",
  "l"), scales = list(y = list(relation = "free")), lwd = c(1, 1),
  col = c("darkgray", "black", "darkgray"), layout = c(1, 2),
  between = list(y = 0.5), strip = FALSE, strip.left = TRUE,
  as.table = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{"stlplus"}.}

\item{xlab, ylab, span, type, scales, lwd, col, layout}{parameters to be passed to
xyplot.}

\item{between, strip, strip.left, as.table, \ldots}{parameters to be passed to
xyplot.}
}
\value{
object of class \code{"trellis"}.
}
\description{
Plots the trend+remainder with the trend component overlaid, and the
remainder component in a separate panel.
}
\references{
R. B. Cleveland, W. S. Cleveland, J. E.  McRae, and I. Terpenning (1990) STL:  A  Seasonal-Trend  Decomposition  Procedure Based on Loess. \emph{Journal of Official Statistics}, \bold{6}, 3--73.
}
\seealso{
\code{\link{stlplus}}
}

