% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_risk_y.R
\name{get_risk_y}
\alias{get_risk_y}
\title{Single transit collision risk along the chord of the rotor at height band
\eqn{y}}
\usage{
get_risk_y(x_at_y, pcoll_doty)
}
\arguments{
\item{x_at_y}{a vector, sequence of horizontal distances from rotor's
vertical axis to points \eqn{x} along half of the rotor circle, expressed
as the proportion of rotor radius, at height band \eqn{y}}

\item{pcoll_doty}{a vector, the single transit collision risk at horizontal
distances \eqn{x}, at height band \eqn{y}}
}
\value{
a numeric value, the single transit collision risk along the whole
horizontal chord of the rotor circle at height band \eqn{y}
}
\description{
Calculates the single transit collision risk/probability along the horizontal
chord of the rotor at height \eqn{y} via numerical integration.
}
\examples{
  rotor_grids <- generate_rotor_grids(yinc = 0.05, xinc = 0.05, chord_prof_5MW)

  y_lt <- dim(rotor_grids$r_grid)[1]

  pcollxy_grid_up <- get_pcoll_grid(
    rotor_grids = rotor_grids,
    direction = 1,
    rotor_radius = 120,
    blade_width = 5,
    rotor_speed = 15,
    blade_pitch = 15,
    flight_type = "flapping",
    n_blades = 3,
    flight_speed = 13.1,
    wing_span = 1.01,
    body_lt = 0.85)

    risk_up <- rep(NA, y_lt)
    for(i in 1:y_lt){
      risk_up[i] <- get_risk_y(rotor_grids$x_grid[i, ], pcollxy_grid_up[i, ])
    }
}
\seealso{
\code{\link[=get_x_grid]{get_x_grid()}}, \code{\link[=get_pcoll_grid]{get_pcoll_grid()}}
}
