% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposal_info.R
\name{print_proposals}
\alias{print_proposals}
\title{Print proposals}
\usage{
print_proposals()
}
\value{
Prints a summary of all proposals, but does not return any value.
}
\description{
This function prints details of all proposals stored by the user. It provides information on each proposal, including the proposal name, size, efficiency, and other relevant details.
}
\examples{
# First, let's create a proposal to sample from a standard normal distribution
f_normal <- function(x) { 0.3989423 * exp(-0.5 * x^2) }
normal_proposal = build_proposal(f = f_normal, modes = 0, lower = -Inf, upper = Inf, steps = 1000)
print(normal_proposal)

# `print_proposals()` prints all proposals stored in R's internal data directory.
# To see this, we first save `normal_proposal` using `save_proposal()`
save_proposal(normal_proposal, "normal")

# Since `normal_proposal` is now stored on this machine,
# we can confirm this by printing all saved proposals
print_proposals()

# Example 2: Create and Save a proposal for a Bimodal Distribution
f_bimodal <- function(x) {
  0.5 * (1 / sqrt(2 * pi)) * exp(-(x^2) / 2) +
  0.5 * (1 / sqrt(2 * pi)) * exp(-((x - 4)^2) / 2)
}
modes_bimodal = c(0, 4)
bimodal_proposal = build_proposal(f = f_bimodal, modes = modes_bimodal,
lower = -Inf, upper = Inf, steps = 1000)

save_proposal(bimodal_proposal, "bimodal")
print(bimodal_proposal)

# To print all stored proposals after saving bimodal_proposal
print_proposals()

}
