% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R
\name{extract_cut_points}
\alias{extract_cut_points}
\title{Extract cutoffs between strata}
\usage{
extract_cut_points(x)
}
\arguments{
\item{x}{an autostrata object}
}
\value{
a vector of the score values delineating cutoffs between strata
}
\description{
By default, returns only the internal cut points.  Cutoffs at 0 and 1 are
implied.
}
\examples{
dat <- make_sample_data()
a.strat <- auto_stratify(dat, "treat", outcome ~ X1 + X2)
cutoffs <- extract_cut_points(a.strat)
}
