% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc}
\alias{lc}
\title{Lethal Concentrations}
\usage{
lc(model, response_name, response_level, reference, warn = TRUE)
}
\arguments{
\item{model}{This can be one of three types of objects: Either the output of
\code{\link{ecxsys}} or the output of \code{\link{predict_ecxsys}} or a
data frame with a "concentration" column and a \code{response_name} column.
In the case of the data frame the first row is assumed to be the control.
See the examples.}

\item{response_name}{The name of the survival or stress for which you want to
calculate the LC.}

\item{response_level}{The desired response level as a percentage between 0
and 100. For example with the value 10 the function will return the LC10,
i.e. the concentration where the response falls below 90 \% of the control
response. In other words: where a mortality of 10 \% relative to the control
is reached.}

\item{reference}{The reference value of the response, usually the control at
concentration 0. This argument is optional. If it is missing, the first
value of the response is used as control. This value determines what number
\code{response_level} actually corresponds to. For example if
response_level is 10 and reference is 45, then the function returns the
concentration where the curve is reduced by 10\% relative to 45 = 40.5.}

\item{warn}{Logical. Should the function emit a warning if the calculation of
the lethal concentration is not possible?}
}
\value{
A list containing the lethal concentration and the corresponding
  survival. The survival will be \code{NA} if its calculation is impossible
  using the supplied data.
}
\description{
Estimate the concentration to reach a certain mortality relative
to the control.
}
\details{
If the response level occurs multiple times because of hormesis, which may
happen for low values of \code{response_level}, then the occurrence with the
smallest concentration is returned.

This function only makes sense for curves which generally go down with
increasing concentration, i.e. all \code{survival_*} curves and also
\code{sys_tox} and \code{sys_tox_env}. Others are untested and may give
unexpected results, if any.
}
\examples{
# Calculate the LC10, the concentration where the survival falls
# below 90\% of the survival in the control.

model <- ecxsys(
    concentration = c(0, 0.05, 0.5, 5, 30),
    hormesis_concentration = 0.5,
    survival_tox_observed = c(90, 81, 92, 28, 0)
)

# using the ecxsys() output or the curves therein directly:
lc(model, "survival_tox_sys", 10)
lc(model$curves, "survival_tox_sys", 10)

# using the output of predict_ecxsys() with custom concentrations:
conc <- 10^seq(-9, 1, length.out = 1000)
curves <- predict_ecxsys(model, conc)
lc(curves, "survival_tox_sys", 10)

# using a custom data frame:
df_custom <- data.frame(
    concentration = curves$concentration,
    foo = curves$survival_tox_sys
)
lc(df_custom, "foo", 10)

# Calculate the LC50 relative to an survival of 100
# instead of relative to the control:
lc(model, "survival_tox_sys", 50, reference = 100)

}
