% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{Score Function for Metrics}
\usage{
score(observed, predicted, ...)
}
\arguments{
\item{observed}{A vector of the observed results.}

\item{predicted}{A data.frame or vector object that is the same number of
rows or length as the length of observed values.}

\item{...}{
  Arguments passed on to \code{\link[=score_classification]{score_classification}}, \code{\link[=score_regression]{score_regression}}
  \describe{
    \item{\code{metrics}}{A character vector of the metrics to be fitted. This is
defaulted to be the metrics from `PyCaret`.}
  }}
}
\value{
A matrix with the various metrics reported.
}
\description{
A score function takes the observed and predicted values and returns a
  vector or data.frame of the various metrics that are reported from `PyCaret`.
  For regression, the following metrics are available: `RMSE`, `MAE`, `MSE`,
  `R2`, `RMSLE`, and `MAPE`. For classification, the following metrics are
  available:`Accuracy`, `AUC`, `Recall`, `Prec.`, `F1`, `MCC`, and `Kappa`.
}
\examples{
lm_data <- data_gen_lm(100)
indices <- split_data_prob(lm_data, .2)
train <- lm_data[!indices,]
test <- lm_data[indices,]
model <- lm(Y ~ ., train)
pred_lm <- predict(model, test)
score(test$Y, pred_lm)
}
