% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isupper.R
\name{strs_isupper}
\alias{strs_isupper}
\title{Check if string is in uppercase}
\usage{
strs_isupper(string)
}
\arguments{
\item{string}{A character vector to be checked.}
}
\value{
A logical vector of the same length as \code{string}, indicating whether
each element is entirely in uppercase.
}
\description{
\code{strs_isupper} checks whether each element of a character vector is in
uppercase. It is similar to Python's \code{str.isupper()} method.
}
\examples{
strs_isupper("HELLO")
strs_isupper("Hello")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.isupper}{Python str.isupper() documentation}
}
