% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{strs_join}
\alias{strs_join}
\title{Join elements into a single string with a separator}
\usage{
strs_join(sep, iterable)
}
\arguments{
\item{sep}{A string separator used to join the elements.}

\item{iterable}{A character vector to be joined.}
}
\value{
A single string with elements of \code{iterable} joined by \code{sep}.
}
\description{
\code{strs_join} concatenates elements of \code{iterable} using \code{sep}. It is similar to
Python's \code{str.join()}.
}
\examples{
strs_join("-", c("hello", "world"))
strs_join("", c("hello", "world"))  # no separator
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.join}{Python str.join() documentation}
}
