% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_trans.R
\name{PAM_categorise}
\alias{PAM_categorise}
\title{PAM_categorise}
\usage{
PAM_categorise(
  tab,
  pam_name = "picture_idx",
  types = c("quadrant", "valence", "arousal")
)
}
\arguments{
\item{tab}{A data.frame (or tibble) with a column representing
Photographic Affect Meter (PAM) score.}

\item{pam_name}{Character. The name of the column
representing PAM.}

\item{types}{Character vector containing the categories,
one or more of "quadrant", "valence" and "arousal" into
which to code PAM scores.}
}
\value{
The data.frame (or tibble) \code{tab} with extra columns
\code{pam_q}, \code{pam_v}, and \code{pam_a} for
quadrant, valence and arousal respectively.
}
\description{
Categorise Photographic Affect Meter (PAM) scores into
4 categories by either PAM Quadrant, Valence or Arousal
(or multiple of these).
}
\details{
The 4 Quadrant categories are as follows:
Quadrant 1: negative valence, low arousal.
Quadrant 2: negative valence, high arousal.
Quadrant 3: positive valence, low arousal.
Quadrant 4: positive valence, high arousal.

Valence and arousal are traditionally
scores from -2 to 2,
measuring displeasure to pleasure, and
state of activation respectively. However,
here we map those scores to positive numbers
so (-2,-1,1,2) -> (1,2,3,4).
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

tab <- load_SL_tibble(
  loc = d, schema = "EMA", table = "PAM", csv_nrows = 10)

PAM_categorise(tab)

}
\references{
Pollak, J. P., Adams, P., & Gay, G. (2011, May).
PAM: a photographic affect meter for frequent,
in situ measurement of affect. In Proceedings of
the SIGCHI conference on Human factors in
computing systems (pp. 725-734). ACM.
}
