% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emp_orth_fun.R
\name{emp_orth_fun}
\alias{emp_orth_fun}
\alias{emp_orth_fun.data.frame}
\alias{emp_orth_fun.stars}
\alias{autoplot.emporthfun}
\title{Computes empirical orthogonal functions using a dataframe or a stars object.}
\usage{
emp_orth_fun(x, ...)

\method{emp_orth_fun}{data.frame}(x, values_df, ...)

\method{emp_orth_fun}{stars}(x, ...)

\method{autoplot}{emporthfun}(
  object,
  EOF_num = 1,
  palette = "Spectral",
  only_EOF = FALSE,
  only_TS = FALSE,
  ...
)
}
\arguments{
\item{x}{The dataframe or stars object. If it is a dataframe, then it should have the locations.}

\item{...}{Other arguments currently ignored.}

\item{values_df}{For dataframes: the dataframe of dimension \code{length(times) x length(locations)} containing the quantity of interest.}

\item{object}{For autoplot: the output of the function `emp_orth_fun'.}

\item{EOF_num}{For autoplot: the number of Empirical Orthogonal Functions (EOFs) to plot.}

\item{palette}{The color palette. Default is \code{Spectral}.}

\item{only_EOF}{For autoplot: if \code{TRUE}, only the spatial EOF function would be plotted.}

\item{only_TS}{For autoplot: if \code{TRUE}, only the PC time series would be plotted. If both are set to \code{FALSE},
both plots would be displayed. Both cannot be set to \code{TRUE}.}
}
\value{
An emporthfun object with temporal PCs and spatial EOFs.
}
\description{
Computes empirical orthogonal functions of the data. Function autoplot can plot the output.
}
\examples{
# dataframe example
data(SSTlonlatshort)
data(SSTdatashort)
data(SSTlandmaskshort)
delete_rows <- which(SSTlandmaskshort  ==  1)
SSTdatashort   <- SSTdatashort[-delete_rows, 1:396]
emp1 <- emp_orth_fun(SSTlonlatshort[-delete_rows,  ],
                     SSTdatashort)
autoplot(emp1,
         EOF_num = 1)


# stars example
library(dplyr)
library(stars)
# Create a stars object from a data frame
precip_df <- NOAA_df_1990[NOAA_df_1990$proc == 'Precip', ] \%>\%
  filter(date >= "1992-02-01" & date <= "1992-02-05")
precip <- precip_df[ ,c('lat', 'lon', 'date', 'z')]
st_precip <- st_as_stars(precip, dims = c("lon", "lat", "date"))
emp <- emp_orth_fun(st_precip)
autoplot(emp, only_TS = TRUE)

}
