% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R, R/rules-indention.R
\name{update_indention}
\alias{update_indention}
\alias{indent_without_paren_for_while_fun}
\alias{indent_without_paren_if_else}
\alias{indent_braces}
\alias{indent_op}
\alias{indent_eq_sub}
\alias{indent_without_paren}
\title{Update indention information of parse data}
\usage{
indent_without_paren_for_while_fun(pd, indent_by)

indent_without_paren_if_else(pd, indent_by)

indent_braces(pd, indent_by)

indent_op(
  pd,
  indent_by,
  token = c(math_token, logical_token, special_token, "PIPE", "LEFT_ASSIGN", "EQ_ASSIGN",
    "'$'", "'~'")
)

indent_eq_sub(pd, indent_by, token = c("EQ_SUB", "EQ_FORMALS"))

indent_without_paren(pd, indent_by = 2L)
}
\arguments{
\item{pd}{A nested or flat parse table that is already enhanced with
line break and space information via \code{\link[=default_style_guide_attributes]{default_style_guide_attributes()}}.}

\item{indent_by}{How many spaces should be added after the token of interest.}

\item{token}{The token the indention should be based on.}
}
\description{
Update indention information of parse data
}
\section{Functions}{
\itemize{
\item \code{indent_without_paren_for_while_fun()}: Is used to indent for and statements and
function definitions without parenthesis.

\item \code{indent_without_paren_if_else()}: Is used to indent if and if-else statements.

\item \code{indent_braces()}: Inserts indention based on round, square and
curly brackets.

\item \code{indent_op()}: Indents \emph{all} tokens after \code{token} - including
the last token.

\item \code{indent_eq_sub()}: Updates indention for token EQ_SUB. Only differs
from \code{\link[=indent_op]{indent_op()}} in the sense that not all subsequent tokens in the parse
table are necessarily indented, as \code{EQ_SUB} and \code{EQ_FORMALS} can occur
multiple times in a parse table.
occurs is not indented (see\code{\link[=compute_indent_indices]{compute_indent_indices()}})

\item \code{indent_without_paren()}: Is used to indent for / while / if / if-else
statements that do not have curly parenthesis.

}}
\keyword{internal}
