% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hazard.R
\name{extract_hazard}
\alias{extract_hazard}
\title{Extract (inverse) cumulative baseline hazard from Cox PH model}
\usage{
extract_hazard(coxphmod)
}
\arguments{
\item{coxphmod}{A call to \code{\link[survival:coxph]{coxph()}}.}
}
\value{
A list containing:
\itemize{
\item \code{cbaseh}: A function which returns the cumulative baseline hazard
at specified time;
\item \code{inv_cbaseh}: A function which returns the inverse cumulative
baseline hazard at specified time.
\item \code{max_time}: maximal time at which \code{cbaseh} is known;
\item \code{max_haz}: value of maximal hazard (at maximum time).
}
}
\description{
Extracts a function which returns the (inverse) cumulative
baseline hazard from a \code{\link[survival:coxph]{coxph()}} call.
}
\details{
The baseline hazard is extracted from the \code{\link[survival:coxph]{coxph()}}
call using the \code{\link[survival:basehaz]{basehaz()}} function. The
baseline hazard function is then smoothed using
\code{\link[stats:approxfun]{approxfun()}} to obtain the linear interpolant.
If required, the inverse baseline hazard is determined using root linear
interpolation. For this, a function written by Zheyuan Li (see references) is used.
}
\examples{
require(survival)
exprfit <- as.formula("Surv(survtime, censorid) ~ age + sex + BMI")
tcoxmod <- coxph(exprfit, data= surgerydat)
tcox_hazard_fcts <- extract_hazard(tcoxmod)


}
\references{
\href{https://stackoverflow.com/users/4891738/zheyuan-li}{Zheyuan Li:}
\href{https://stackoverflow.com/questions/52650467/how-to-estimate-x-value-from-y-value-input-after-approxfun-in-r}{How to estimate x value from y value input after approxfun in R?} (accessed: 09/10/2023)
}
\seealso{
\code{\link[survival:coxph]{coxph}}
}
\author{
Daniel Gomon
}
