% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{solve.sudoku}
\alias{solve.sudoku}
\title{Solve a Sudoku Puzzle}
\usage{
\method{solve}{sudoku}(a, ...)
}
\arguments{
\item{a}{A sudoku game object to be solved}

\item{...}{Extra arguments (curently ignored)}
}
\value{
a solved game, or NULL if no solution exists.
}
\description{
Solve a Sudoku Puzzle
}
\details{
An alternative front end to \code{solveGame} as a method for the base generic function \code{solve}.
}
\examples{
set.seed(1234)
makeGame(3, gaps = 59) \%>\% solve \%>\% plot -> sg
originalGame(sg)

g <- emptyGame(4)  # construct a patterned game
diag(g) <- LETTERS[1:16]
g \%>\% solve \%>\% plot -> sg
sg
}
\author{
Bill Venables
}
