% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SF.CI.R
\name{SF.CI}
\alias{SF.CI}
\title{Conformal inference of the sufficient forecasting}
\usage{
SF.CI(
  y,
  X,
  newX = NULL,
  type = "LM",
  K = "default",
  L = 1,
  alpha = 0.1,
  discretization = TRUE,
  nslices = 10
)
}
\arguments{
\item{y}{Response, T by 1 matrix}

\item{X}{Predictors, p by T matrix}

\item{newX}{New predictors, a vector contains p entries (or \code{NULL})}

\item{type}{\code{LM} or \code{LLM} (default = \code{LM})}

\item{K}{The number of common factors (default = obtained
by \code{\link{getK}})}

\item{L}{The number of predictive indices, L is required to be no greater than
K (default = 1)}

\item{alpha}{Mis-coverage rate}

\item{discretization}{Hyperparameter in SIR (default = \code{TRUE})}

\item{nslices}{Hyperparameter in SIR (default = 10)}
}
\value{
A list with components
\describe{
\item{yhat}{Out-of-sample forecast for \code{newX}; or in-sample forecast
for the last observed data point if \code{newX} is \code{NULL}}
\item{ci_lower}{Lower bound of conformal interval}
\item{ci_upper}{Upper bound of conformal interval}
}
}
\description{
Conformal inference of the sufficient forecasting
}
\examples{
utils::data(dataExample,package = "sufficientForecasting")
SF.CI(dataExample$y,dataExample$X,type = "LM",alpha = 0.05)
}
\references{
Yu, X., Yao, J. and Xue, L. (2022), Nonparametric estimation and conformal inference
of the sufficient forecasting with a diverging number of factors,
\emph{Journal of Business & Economic Statistics} 40(1), 342–354.
}
