% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_installed.R
\name{is_installed}
\alias{is_installed}
\title{Check whether packages are installed}
\usage{
is_installed(pkgs, load = FALSE, lib.loc = NULL)
}
\arguments{
\item{pkgs}{A character vector of package names. You can check for a minimum
version by appending \verb{>=[version]} to a package name - see Examples.}

\item{load}{Whether to make sure packages can be loaded - significantly
slower, but gives an extra level of certainty.}

\item{lib.loc}{Passed to \code{\link[utils:packageDescription]{utils::packageVersion()}}.}
}
\value{
A logical vector of the same length as \code{pkgs}, where each element is
\code{TRUE} if the package is installed, and \code{FALSE} otherwise.
}
\description{
Initially, \code{\link[utils:packageDescription]{utils::packageVersion()}} is used to try to retrieve a version
from a package's \code{DESCRIPTION} file. This is a fast method, but doesn't
categorically guarantee that the package is actually available to use.

If \code{load = TRUE}, then \code{\link[base:ns-load]{base::requireNamespace()}} is used to try to load the
namespace of each package in turn. This is much slower, but is the closest we
can get to ensuring that the package is genuinely usable.
}
\examples{
  is_installed("base")
  is_installed(c("base", "utils"))

  is_installed("base>=3.0.0")
  is_installed(c(
    "base>=3.0.0",
    "utils"
  ))

}
