% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.svydesign.R
\name{cv.svydesign}
\alias{cv.svydesign}
\title{CV for \code{svydesign} objects}
\usage{
cv.svydesign(
  design_object,
  formulae,
  nfolds = 5,
  method = c("linear", "logistic"),
  na.rm = FALSE
)
}
\arguments{
\item{design_object}{Name of a \code{svydesign} object created using the \code{survey}
package. We do not yet support use of \code{probs} or \code{pps}.}

\item{formulae}{Vector of formulas (as strings) for the GLMs to be compared in
cross validation}

\item{nfolds}{Number of folds to be used during cross validation, defaults to
5}

\item{method}{String, must be either "linear" or "logistic", determines type of
model fit during cross validation, defaults to linear}

\item{na.rm}{Whether to drop cases with missing values when taking `svymean`
of test losses}
}
\value{
Object of class \code{svystat}, which is a named vector of survey CV estimates of the mean loss
  (MSE for linear models, or binary cross-entropy for logistic models) for each model,
  with names ".Model_1", ".Model_2", etc. corresponding to the models provided in \code{formulae};
  and with a \code{var} attribute giving the variances.
  See \code{\link[survey]{surveysummary}} for details.
}
\description{
Wrapper function which takes a \code{\link[survey]{svydesign}} object
and a vector of model formulas (as strings),
and passes it into \code{\link{cv.svy}}.
Returns survey CV estimates of the mean loss for each model
(MSE for linear models, or binary cross-entropy for logistic models).
}
\details{
If you have already fitted a \code{svyglm},
you may prefer the convenience wrapper function
\code{\link{cv.svyglm}}.

For models other than linear or logistic regression,
you can use \code{\link{folds.svy}} or \code{\link{folds.svydesign}} to generate
CV fold IDs that respect any stratification or clustering in the survey design.
You can then carry out K-fold CV as usual,
taking care to also use the survey design features and survey weights
when fitting models in each training set
and also when evaluating models against each test set.
}
\examples{
# Compare CV MSEs and their SEs under 3 linear models
# for a stratified sample and a one-stage cluster sample,
# using data from the `survey` package
library(survey)
data("api", package = "survey")
# stratified sample
dstrat <- svydesign(id = ~1, strata = ~stype, weights = ~pw, data = apistrat,
                    fpc = ~fpc)
cv.svydesign(formulae = c("api00~ell",
                          "api00~ell+meals",
                          "api00~ell+meals+mobility"),
             design_object = dstrat, nfolds = 5)
# one-stage cluster sample
dclus1 <- svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)
cv.svydesign(formulae = c("api00~ell",
                          "api00~ell+meals",
                          "api00~ell+meals+mobility"),
             design_object = dclus1, nfolds = 5)

# Compare CV MSEs and their SEs under 3 linear models
# for a stratified cluster sample with clusters nested within strata
data(NSFG_data)
library(splines)
NSFG.svydes <- svydesign(id = ~SECU, strata = ~strata, nest = TRUE,
                         weights = ~wgt, data = NSFG_data)
cv.svydesign(formulae = c("income ~ ns(age, df = 2)",
                          "income ~ ns(age, df = 3)",
                          "income ~ ns(age, df = 4)"),
             design_object = NSFG.svydes, nfolds = 4)

# Logistic regression example, using the same stratified cluster sample;
# instead of CV MSE, we calculate CV binary cross-entropy loss,
# where (as with MSE) lower values indicate better fitting models
# (NOTE: na.rm=TRUE is not usually ideal;
#  it's used below purely for convenience, to keep the example short,
#  but a thorough analysis would look for better ways to handle the missing data)
cv.svydesign(formulae = c("KnowPreg ~ ns(age, df = 1)",
                          "KnowPreg ~ ns(age, df = 2)",
                          "KnowPreg ~ ns(age, df = 3)"),
             design_object = NSFG.svydes, nfolds = 4,
             method = "logistic", na.rm = TRUE)
}
\seealso{
\code{\link[survey]{surveysummary}}, \code{\link[survey]{svydesign}}

\code{\link{cv.svyglm}} for a wrapper to use with a \code{svyglm} object
}
