% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directEST.R
\name{directEST}
\alias{directEST}
\title{Calculate direct estimates}
\usage{
directEST(
  data,
  cluster.info,
  admin,
  strata = "all",
  CI = 0.95,
  weight = c("population", "survey")[1],
  admin.info = NULL,
  aggregation = FALSE,
  ...
)
}
\arguments{
\item{data}{dataframe that contains the indicator of interests, output of getDHSindicator function}

\item{cluster.info}{list contains data and wrong.points. data contains admin 1 and admin 2 information and coordinates for each cluster. wrong.points. contains cluster id for cluster without coordinates or admin 1 information. Output of getDHSindicator function}

\item{admin}{admin level for the model.}

\item{strata}{use only urban or rural data, only for national level model}

\item{CI}{Credible interval to be used. Default to 0.95.}

\item{weight}{the weight used for aggregating result, "population" or "survey"}

\item{admin.info}{list contains data and mat, data contains population and urban/rural proportion at specific admin level and mat is the adjacency matrix, output of adminInfo function}

\item{aggregation}{whether or not report aggregation results.}

\item{...}{Additional arguments passed on to the `smoothSurvey` function}
}
\value{
This function returns the dataset that contain district name and population for given  tiff files and polygons of admin level,
}
\description{
This function calculate direct estimates at given admin level.
}
\examples{
\dontrun{
geo <- getDHSgeo(country = "Zambia", year = 2018)
data(ZambiaAdm1)
data(ZambiaAdm2)
data(ZambiaPopWomen)
cluster.info<-clusterInfo(geo=geo, poly.adm1=poly.adm1, poly.adm2=poly.adm2,
by.adm1 = "NAME_1",by.adm2 = "NAME_2")
dhsData <- getDHSdata(country = "Zambia",
                                 indicator = "ancvisit4+",
                                 year = 2018)

data <- getDHSindicator(dhsData, indicator = "ancvisit4+")
res_ad1 <- directEST(data = data,
                  cluster.info = cluster.info,
                  admin = 1,
                  aggregation = FALSE)
res_ad1
# compare with the DHS direct estimates
dhs_table <- get_api_table(country = "ZM",
                           survey = "ZM2018DHS",
                           indicator = "RH_ANCN_W_N4P",
                           simplify = TRUE)
subset(dhs_table, ByVariableLabel == "Five years preceding the survey")

}

}
\author{
Qianyu Dong
}
